import { NextRequest, NextResponse } from 'next/server';
import Database from 'better-sqlite3';
import path from 'path';

function getDb() {
    const dbPath = path.join(process.cwd(), 'domains.db');
    return new Database(dbPath);
}

export async function GET(_: NextRequest, { params }: { params: Promise<{ id: string }> }) {
    const { id } = await params;
    const db = getDb();
    try {
        const projects = db.prepare('SELECT * FROM projects WHERE customer_id = ? ORDER BY title').all(id);
        return NextResponse.json(projects);
    } catch (e: any) {
        console.error('Get customer projects error:', e);
        return NextResponse.json({ error: 'שגיאה בטעינת פרויקטים: ' + e.message }, { status: 500 });
    } finally {
        db.close();
    }
}
